--[[
Part of Production Storage Control FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]

SlotSystem.NUM_OBJECT_LIMITS = {
	[SlotSystem.LIMITED_OBJECT_BALE] = {
		[PlatformId.WIN] = math.huge,
		[PlatformId.MAC] = math.huge,
		[PlatformId.PS5] = 200,
		[PlatformId.XBOX_SERIES] = 200,
		[PlatformId.IOS] = 100,
		[PlatformId.ANDROID] = 100,
		[PlatformId.SWITCH] = 100
	},
	[SlotSystem.LIMITED_OBJECT_PALLET] = {
		[PlatformId.WIN] = math.huge,
		[PlatformId.MAC] = math.huge,
		[PlatformId.PS5] = 150,
		[PlatformId.XBOX_SERIES] = 150,
		[PlatformId.IOS] = 50,
		[PlatformId.ANDROID] = 50,
		[PlatformId.SWITCH] = 50
	}
}


ProductionChainManager.NUM_MAX_PRODUCTION_POINTS = 360
FillTypeManager.SEND_NUM_BITS = 10

Logging.info("Changed limits - Productions (%s), Pallets (%s) and FillType(%s)", ProductionChainManager.NUM_MAX_PRODUCTION_POINTS, SlotSystem.NUM_OBJECT_LIMITS[SlotSystem.LIMITED_OBJECT_PALLET][PlatformId.WIN], 2^FillTypeManager.SEND_NUM_BITS)