--[[
Part of Production Storage Control FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]

function productionStorageControl:updateMenuButtonsAppend(superFunc)
	if self.pointsSelector:getState() == InGameMenuProductionFrame.POINTS_OWNED then
		if g_currentMission:getHasPlayerPermission("manageProductions") then
			local production, productionPoint = self:getSelectedProduction()
			if productionPoint ~= nil and productionPoint.palletSpawner ~= nil then
				table.insert(self.menuButtonInfo, {
					profile = "buttonOk",
					inputAction = InputAction.ACTIVATE_OBJECT,
					text = g_i18n:getText("ProductionStorageControl_ButtonSpawn"),
					callback = function()
						productionPoint.activatable:run(true)
					end
				})
			end
		end
	end
end

InGameMenuProductionFrame.updateMenuButtons = Utils.appendedFunction(InGameMenuProductionFrame.updateMenuButtons, productionStorageControl.updateMenuButtonsAppend)


function productionStorageControl:onButtonToggleOutputMode(superFunc)
	if g_currentMission:getHasPlayerPermission("manageProductions") then
		local production, productionPoint = self:getSelectedProduction()
		ProductionSettingsDialog.show(function(item) productionPoint:ReceiveSpawnEvent() end, nil, productionPoint:getName(), productionPoint)
	else
		InfoDialog:show(g_i18n:getText("shop_messageNoPermissionGeneral"), nil, nil, DialogElement.TYPE_WARNING)
	end
end

InGameMenuProductionFrame.onButtonToggleOutputMode = Utils.overwrittenFunction(InGameMenuProductionFrame.onButtonToggleOutputMode, productionStorageControl.onButtonToggleOutputMode)