-- unlimitedFillTypes.lua
-- Strategy: set SEND_NUM_BITS early and patch addFillType to auto-increase if needed.

local TARGET_BITS = 12

if FillTypeManager ~= nil then
    local oldBits = FillTypeManager.SEND_NUM_BITS or 8
    if TARGET_BITS > oldBits then
        FillTypeManager.SEND_NUM_BITS = TARGET_BITS
        print(string.format("[unlimitedFillTypes] Early set SEND_NUM_BITS: %d -> %d (Limit %d)",
            oldBits, FillTypeManager.SEND_NUM_BITS, 2 ^ FillTypeManager.SEND_NUM_BITS - 1))
    end

    if FillTypeManager.addFillType ~= nil and not FillTypeManager._unlimitedPatched then
        local _origAdd = FillTypeManager.addFillType
        FillTypeManager.addFillType = function(self, fillTypeDesc)
            local wanted = (#self.fillTypes) + 1
            local maxNow = 2 ^ FillTypeManager.SEND_NUM_BITS - 1

            if wanted > maxNow then
                local startBits = FillTypeManager.SEND_NUM_BITS
                while wanted > (2 ^ FillTypeManager.SEND_NUM_BITS - 1)
                  and FillTypeManager.SEND_NUM_BITS < 15 do
                    FillTypeManager.SEND_NUM_BITS = FillTypeManager.SEND_NUM_BITS + 1
                end

                print(string.format(
                    "[unlimitedFillTypes] Auto-bumped SEND_NUM_BITS: %d -> %d (Limit %d)",
                    startBits,
                    FillTypeManager.SEND_NUM_BITS,
                    2 ^ FillTypeManager.SEND_NUM_BITS - 1
                ))
            end

            return _origAdd(self, fillTypeDesc)
        end

        FillTypeManager._unlimitedPatched = true
    end
else
    print("[unlimitedFillTypes] Warning: FillTypeManager not yet available at file load.")
end

unlimitedFillTypes = {}

function unlimitedFillTypes:loadMap(name)
    if FillTypeManager ~= nil then
        if FillTypeManager.SEND_NUM_BITS < TARGET_BITS then
            local oldBits = FillTypeManager.SEND_NUM_BITS
            FillTypeManager.SEND_NUM_BITS = TARGET_BITS
            print(string.format(
                "[unlimitedFillTypes] Fallback set SEND_NUM_BITS: %d -> %d (Limit %d)",
                oldBits,
                FillTypeManager.SEND_NUM_BITS,
                2 ^ FillTypeManager.SEND_NUM_BITS - 1
            ))
        end
    end
end

function unlimitedFillTypes:deleteMap() end
function unlimitedFillTypes:keyEvent() end
function unlimitedFillTypes:mouseEvent() end
function unlimitedFillTypes:update() end
function unlimitedFillTypes:draw() end

addModEventListener(unlimitedFillTypes)
