--
-- add compost as Spraytype to use it like manure
--

Compost = {};
Compost.xmlSchema = {};

Compost.currentModName = "";
Compost.currentModDirectory = "";

local modDirectory = g_currentModDirectory;

for _, mod in pairs(g_modManager.mods) do
	if mod.title:upper() == "COMPOST" or mod.title:upper() == "KOMPOST" then		
		if g_modIsLoaded[mod.modName] then	
			Compost.currentModName = mod.modName;
			Compost.currentModDirectory = mod.modDir;

			break;
		end;
	end;
end;

function Compost:loadDefaultTypes()
	local sprayTypesXML = loadXMLFile("sprayTypes", Utils.getFilename("sprayTypes.xml", Compost.currentModDirectory));

	if sprayTypesXML ~= nil then
		self:loadSprayTypes(sprayTypesXML, nil, true);

		delete(sprayTypesXML);
	end;
end

function Compost:registerManureSpreaderEffects()
    local motionPathXML = XMLFile.load("motionPathXML", Utils.getFilename("motionPathEffects.xml", Compost.currentModDirectory), Compost.xmlSchema);

    if motionPathXML ~= nil then
		g_motionPathEffectManager:loadMotionPathEffects(motionPathXML.handle, "motionPathEffects.motionPathEffect", Compost.currentModDirectory, Compost.currentModName);

        motionPathXML:delete();
    end;
end;

local effectsToMerge = {
    ["MANURE_COMPOST_SPREADER"] = {
        into = "MANURE_SPREADER",
        fallbackFillTypeStr = "MANURE",
        fallbackEffectMeshIndex = 1
    }
}

local function mergeEffects()
    for from, intoData in pairs(effectsToMerge) do
        local intoEffects = g_motionPathEffectManager.effectsByType[intoData.into:upper()];

        if intoEffects ~= nil then
            local fromEffects = g_motionPathEffectManager.effectsByType[from:upper()];

            for _, intoEffect in pairs(intoEffects) do
                if #intoEffect.effectMaterials == 0 and intoData.fallbackFillTypeStr ~= nil then
                    local node = intoEffect.effectMeshes[intoData.fallbackEffectMeshIndex or 1].node;

                    local effectMaterial = {
                        node = node,
                        materialId = getMaterial(node, 0),
                        parent = intoEffect,
                        lod = {},
                        fillTypes = {g_fillTypeManager:getFillTypeIndexByName(intoData.fallbackFillTypeStr)},
                        fruitTypes = nil,
                        growthStates = nil,
                        customShaderMaps = {},
                        customShaderParameters = {},
                    };

                    table.insert(intoEffect.effectMaterials, effectMaterial);
                end;

                for _, fromEffect in pairs(fromEffects) do
                    intoEffect.customShaderVariation = fromEffect.customShaderVariation;

                    for _, effectMesh in pairs(fromEffect.effectMeshes) do
                        table.insert(intoEffect.effectMeshes, effectMesh);
                    end;

                    for _, effectMaterial in pairs(fromEffect.effectMaterials) do
                        table.insert(intoEffect.effectMaterials, effectMaterial);
                    end;
                end;
            end;
        else
            Logging.error("Enhanced fillType categories is missing the effect type %s in your map, please check for mod conflicts!", intoData.into);
        end;
    end;
end;

local function init()
    SprayTypeManager.loadDefaultTypes = Utils.appendedFunction(SprayTypeManager.loadDefaultTypes, Compost.loadDefaultTypes);
	MotionPathEffectManager.loadMapData = Utils.appendedFunction(MotionPathEffectManager.loadMapData, Compost.registerManureSpreaderEffects);
	FSBaseMission.onFinishedLoading  = Utils.prependedFunction(FSBaseMission.onFinishedLoading, mergeEffects);
end;

init();